{{-- resources/views/products/index.blade.php --}}
@extends('layouts.app')

@section('page-title', 'المنتجات')

@section('content')
    <div class="card">
        <div class="card-header bg-white d-flex justify-content-between align-items-center">
            <h5 class="mb-0"><i class="bi bi-box-seam"></i> قائمة المنتجات</h5>
            <div>
                <a href="{{ route('products.low-stock') }}" class="btn btn-warning btn-sm me-2">
                    <i class="bi bi-exclamation-triangle"></i> منتجات أوشكت على النفاذ
                </a>
                <a href="{{ route('products.create') }}" class="btn btn-primary">
                    <i class="bi bi-plus-circle"></i> إضافة منتج جديد
                </a>
            </div>
        </div>
        <div class="card-body">
            <form method="GET" class="row g-3 mb-4">
                <div class="col-md-4">
                    <input type="text" name="search" class="form-control" placeholder="البحث بالاسم أو الباركود..."
                           value="{{ request('search') }}">
                </div>
                <div class="col-md-3">
                    <select name="category_id" class="form-select">
                        <option value="">كل الفئات</option>
                        @foreach($categories as $category)
                            <option value="{{ $category->id }}" {{ request('category_id') == $category->id ? 'selected' : '' }}>
                                {{ $category->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <div class="form-check mt-2">
                        <input class="form-check-input" type="checkbox" name="low_stock" id="lowStock"
                            {{ request('low_stock') ? 'checked' : '' }}>
                        <label class="form-check-label" for="lowStock">منتجات قليلة</label>
                    </div>
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="bi bi-search"></i> بحث
                    </button>
                </div>
            </form>

            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                    <tr>
                        <th>الصورة</th>
                        <th>الاسم</th>
                        <th>الباركود</th>
                        <th>الفئة</th>
                        <th>سعر الشراء</th>
                        <th>سعر البيع</th>
                        <th>الكمية</th>
                        <th>الصلاحية</th>
                        <th>إجراءات</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($products as $product)
                        <tr class="{{ $product->isLowStock() ? 'table-warning' : '' }}">
                            <td>
                                @if($product->image)
                                    <img src="{{ asset('storage/' . $product->image) }}" width="50" height="50" class="rounded">
                                @else
                                    <div class="bg-light rounded" style="width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                        <i class="bi bi-box-seam"></i>
                                    </div>
                                @endif
                            </td>
                            <td><strong>{{ $product->name }}</strong></td>
                            <td>{{ $product->barcode }}</td>
                            <td><span class="badge bg-info">{{ $product->category->name }}</span></td>
                            <td>{{ number_format($product->cost_price, 2) }} ج.م</td>
                            <td><strong>{{ number_format($product->selling_price, 2) }} ج.م</strong></td>
                            <td>
                                @if($product->isLowStock())
                                    <span class="badge bg-danger">{{ $product->quantity }}</span>
                                @else
                                    <span class="badge bg-success">{{ $product->quantity }}</span>
                                @endif
                            </td>
                            <td>
                                @if($product->expiry_date)
                                    @if($product->isExpired())
                                        <span class="badge bg-danger">منتهي</span>
                                    @elseif($product->isExpiringSoon())
                                        <span class="badge bg-warning">{{ $product->expiry_date->format('Y-m-d') }}</span>
                                    @else
                                        <span class="badge bg-success">{{ $product->expiry_date->format('Y-m-d') }}</span>
                                    @endif
                                @else
                                    -
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('products.show', $product) }}" class="btn btn-sm btn-info btn-action">
                                    <i class="bi bi-eye"></i>
                                </a>
                                <a href="{{ route('products.edit', $product) }}" class="btn btn-sm btn-primary btn-action">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <form action="{{ route('products.destroy', $product) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger btn-action"
                                            onclick="return confirm('هل أنت متأكد؟')">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="text-center py-4">لا توجد منتجات</td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>

            {{ $products->links() }}
        </div>
    </div>
@endsection
