{{-- resources/views/reports/purchases.blade.php --}}
@extends('layouts.app')

@section('page-title', 'تقرير المشتريات')

@section('content')
    <div class="card">
        <div class="card-header bg-white">
            <h5 class="mb-0"><i class="bi bi-bag-plus"></i> تقرير المشتريات</h5>
        </div>
        <div class="card-body">
            <form method="GET" class="row g-3 mb-4">
                <div class="col-md-4">
                    <label class="form-label">من تاريخ</label>
                    <input type="date" name="date_from" class="form-control"
                           value="{{ request('date_from', \Carbon\Carbon::parse($dateFrom)->format('Y-m-d')) }}"
                    >
                </div>
                <div class="col-md-4">
                    <label class="form-label">إلى تاريخ</label>
                    <input type="date" name="date_to" class="form-control"
                           value="{{ request('date_to', \Carbon\Carbon::parse($dateTo)->format('Y-m-d')) }}"

                    >
                </div>
                <div class="col-md-4">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="bi bi-search"></i> عرض التقرير
                    </button>
                </div>
            </form>

            <div class="row g-3 mb-4">
                <div class="col-md-4">
                    <div class="stat-card primary">
                        <h6>إجمالي المشتريات</h6>
                        <h3>{{ number_format($totalPurchases, 2) }} ج.م</h3>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-card success">
                        <h6>المدفوع</h6>
                        <h3>{{ number_format($totalPaid, 2) }} ج.م</h3>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-card warning">
                        <h6>المتبقي</h6>
                        <h3>{{ number_format($totalRemaining, 2) }} ج.م</h3>
                    </div>
                </div>
            </div>

            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                    <tr>
                        <th>رقم الفاتورة</th>
                        <th>المورد</th>
                        <th>المبلغ الإجمالي</th>
                        <th>المدفوع</th>
                        <th>المتبقي</th>
                        <th>حالة الدفع</th>
                        <th>التاريخ</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($purchases as $purchase)
                        <tr>
                            <td><strong>{{ $purchase->invoice_number }}</strong></td>
                            <td>{{ $purchase->supplier->name }}</td>
                            <td>{{ number_format($purchase->total_amount, 2) }} ج.م</td>
                            <td>{{ number_format($purchase->paid_amount, 2) }} ج.م</td>
                            <td>{{ number_format($purchase->remainingAmount(), 2) }} ج.م</td>
                            <td>
                                @if($purchase->payment_status == 'paid')
                                    <span class="badge bg-success">مدفوع</span>
                                @elseif($purchase->payment_status == 'partial')
                                    <span class="badge bg-warning">جزئي</span>
                                @else
                                    <span class="badge bg-danger">غير مدفوع</span>
                                @endif
                            </td>
                            <td>{{ $purchase->created_at->format('Y-m-d') }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center py-4">لا توجد مشتريات في هذه الفترة</td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
