@extends('layouts.app')

@section('page-title', 'تقرير المبيعات')

@section('content')
    <div class="card">
        <div class="card-header bg-white">
            <h5 class="mb-0"><i class="bi bi-graph-up"></i> تقرير المبيعات</h5>
        </div>
        <div class="card-body">
            <form method="GET" class="row g-3 mb-4">
                <div class="col-md-4">
                    <label class="form-label">من تاريخ</label>
                    <input type="date" name="date_from" class="form-control"
                           value="{{ request('date_from', \Carbon\Carbon::parse($dateFrom)->format('Y-m-d')) }}"
                    >
                </div>
                <div class="col-md-4">
                    <label class="form-label">إلى تاريخ</label>
                    <input type="date" name="date_to" class="form-control"
                           value="{{ request('date_to', \Carbon\Carbon::parse($dateTo)->format('Y-m-d')) }}"

                        >
                </div>
                <div class="col-md-4">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="bi bi-search"></i> عرض التقرير
                    </button>
                </div>
            </form>

            <div class="row g-3 mb-4">
                <div class="col-md-4">
                    <div class="stat-card primary">
                        <h6>إجمالي المبيعات</h6>
                        <h3>{{ number_format($totalSales, 2) }} ج.م</h3>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-card success">
                        <h6>عدد العمليات</h6>
                        <h3>{{ $totalTransactions }}</h3>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-card warning">
                        <h6>إجمالي الخصومات</h6>
                        <h3>{{ number_format($totalDiscount, 2) }} ج.م</h3>
                    </div>
                </div>
            </div>

            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                    <tr>
                        <th>التاريخ</th>
                        <th>عدد العمليات</th>
                        <th>الخصم</th>
                        <th>الإجمالي</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($sales as $sale)
                        <tr>
                            <td>{{ $sale->date }}</td>
                            <td><span class="badge bg-primary">{{ $sale->count }}</span></td>
                            <td>{{ number_format($sale->discount, 2) }} ج.م</td>
                            <td><strong>{{ number_format($sale->total, 2) }} ج.م</strong></td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
