<?php
// routes/web.php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\PurchaseController;
use App\Http\Controllers\POSController;
use App\Http\Controllers\SaleController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\UserController;

Route::get('/', function () {
    return redirect()->route('login');
});

Auth::routes();

Route::middleware(['auth'])->group(function () {

    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // Categories
    Route::resource('categories', CategoryController::class);

    // Suppliers
    Route::resource('suppliers', SupplierController::class);

    // Products
    Route::resource('products', ProductController::class);
    Route::get('products/barcode/{barcode}', [ProductController::class, 'getByBarcode'])
        ->name('products.barcode');
    Route::get('products-low-stock', [ProductController::class, 'lowStock'])
        ->name('products.low-stock');
    Route::get('products-expiring', [ProductController::class, 'expiring'])
        ->name('products.expiring');

    // Purchases
    Route::resource('purchases', PurchaseController::class)
        ->except(['edit', 'update']);

    // POS
    Route::get('/pos', [POSController::class, 'index'])->name('pos.index');
    Route::post('/pos', [POSController::class, 'store'])->name('pos.store');
    Route::get('/pos/receipt/{id}', [POSController::class, 'receipt'])->name('pos.receipt');

    // Sales
    Route::resource('sales', SaleController::class)->only(['index', 'show', 'destroy']);

    // Reports (Admin & Manager only)
    Route::middleware(['check.role:admin,manager'])->prefix('reports')->name('reports.')->group(function () {
        Route::get('/', [ReportController::class, 'index'])->name('index');
        Route::get('/sales', [ReportController::class, 'sales'])->name('sales');
        Route::get('/purchases', [ReportController::class, 'purchases'])->name('purchases');
        Route::get('/profit', [ReportController::class, 'profit'])->name('profit');
        Route::get('/inventory', [ReportController::class, 'inventory'])->name('inventory');
        Route::get('/top-products', [ReportController::class, 'topProducts'])->name('top-products');
    });

    // Users (Admin only)
    Route::middleware(['check.role:admin'])->group(function () {
        Route::resource('users', UserController::class);
    });
});
