<?php $__env->startSection('page-title', 'تقرير الأرباح'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header bg-white">
            <h5 class="mb-0"><i class="bi bi-currency-dollar"></i> تقرير الأرباح والخسائر</h5>
        </div>
        <div class="card-body">
            <form method="GET" class="row g-3 mb-4">
                <div class="col-md-4">
                    <label class="form-label">من تاريخ</label>
                    <input type="date" name="date_from" class="form-control"
                           value="<?php echo e(request('date_from', $dateFrom->format('Y-m-d'))); ?>">
                </div>
                <div class="col-md-4">
                    <label class="form-label">إلى تاريخ</label>
                    <input type="date" name="date_to" class="form-control"
                           value="<?php echo e(request('date_to', $dateTo->format('Y-m-d'))); ?>">
                </div>
                <div class="col-md-4">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="bi bi-search"></i> عرض التقرير
                    </button>
                </div>
            </form>

            <div class="row g-4">
                <div class="col-md-6">
                    <div class="card border-success">
                        <div class="card-body text-center py-5">
                            <i class="bi bi-arrow-up-circle fs-1 text-success mb-3"></i>
                            <h6 class="text-muted">إجمالي الإيرادات</h6>
                            <h2 class="text-success"><?php echo e(number_format($revenue, 2)); ?> ج.م</h2>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card border-danger">
                        <div class="card-body text-center py-5">
                            <i class="bi bi-arrow-down-circle fs-1 text-danger mb-3"></i>
                            <h6 class="text-muted">إجمالي التكاليف</h6>
                            <h2 class="text-danger"><?php echo e(number_format($cost, 2)); ?> ج.م</h2>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card border-primary">
                        <div class="card-body text-center py-5">
                            <i class="bi bi-cash-stack fs-1 text-primary mb-3"></i>
                            <h6 class="text-muted">صافي الربح</h6>
                            <h2 class="text-primary"><?php echo e(number_format($profit, 2)); ?> ج.م</h2>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card border-info">
                        <div class="card-body text-center py-5">
                            <i class="bi bi-percent fs-1 text-info mb-3"></i>
                            <h6 class="text-muted">هامش الربح</h6>
                            <h2 class="text-info"><?php echo e(number_format($profitMargin, 2)); ?>%</h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\2025\supermarket-pos\resources\views/reports/profit.blade.php ENDPATH**/ ?>