<?php $__env->startSection('page-title', 'تفاصيل الفاتورة'); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-lg-10 mx-auto">
            <div class="card">
                <div class="card-header bg-white d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="bi bi-receipt"></i> فاتورة: <?php echo e($sale->invoice_number); ?></h5>
                    <div>
                        <a href="<?php echo e(route('pos.receipt', $sale)); ?>" class="btn btn-primary btn-sm" target="_blank">
                            <i class="bi bi-printer"></i> طباعة
                        </a>
                        <a href="<?php echo e(route('sales.index')); ?>" class="btn btn-secondary btn-sm">
                            <i class="bi bi-arrow-right"></i> رجوع
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h6>معلومات الفاتورة:</h6>
                            <p class="mb-1"><strong>رقم الفاتورة:</strong> <?php echo e($sale->invoice_number); ?></p>
                            <p class="mb-1"><strong>التاريخ:</strong> <?php echo e($sale->created_at->format('Y-m-d H:i:s')); ?></p>
                            <p class="mb-1"><strong>الكاشير:</strong> <?php echo e($sale->user->name); ?></p>
                            <p class="mb-0">
                                <strong>طريقة الدفع:</strong>
                                <?php if($sale->payment_method == 'cash'): ?>
                                    <span class="badge bg-success">نقدي</span>
                                <?php elseif($sale->payment_method == 'card'): ?>
                                    <span class="badge bg-primary">بطاقة</span>
                                <?php else: ?>
                                    <span class="badge bg-info">محفظة إلكترونية</span>
                                <?php endif; ?>
                            </p>
                        </div>
                        <div class="col-md-6 text-end">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h6 class="text-muted mb-3">ملخص الفاتورة</h6>
                                    <p class="mb-2">
                                        <span>المجموع الفرعي:</span>
                                        <strong><?php echo e(number_format($sale->subtotal, 2)); ?> ج.م</strong>
                                    </p>
                                    <?php if($sale->discount > 0): ?>
                                        <p class="mb-2 text-danger">
                                            <span>الخصم:</span>
                                            <strong>- <?php echo e(number_format($sale->discount, 2)); ?> ج.م</strong>
                                        </p>
                                    <?php endif; ?>
                                    <hr>
                                    <p class="mb-0">
                                        <span class="fs-5">الإجمالي:</span>
                                        <strong class="fs-4 text-success"><?php echo e(number_format($sale->total_amount, 2)); ?> ج.م</strong>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <h6 class="mb-3">المنتجات:</h6>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>المنتج</th>
                                <th>الكمية</th>
                                <th>سعر الوحدة</th>
                                <th>المجموع</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $sale->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($index + 1); ?></td>
                                    <td><?php echo e($item->product->name); ?></td>
                                    <td><?php echo e($item->quantity); ?></td>
                                    <td><?php echo e(number_format($item->unit_price, 2)); ?> ج.م</td>
                                    <td><strong><?php echo e(number_format($item->total_price, 2)); ?> ج.م</strong></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-6 offset-md-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between mb-2">
                                        <span>المدفوع:</span>
                                        <strong><?php echo e(number_format($sale->paid_amount, 2)); ?> ج.م</strong>
                                    </div>
                                    <div class="d-flex justify-content-between">
                                        <span>الباقي:</span>
                                        <strong class="text-success"><?php echo e(number_format($sale->change_amount, 2)); ?> ج.م</strong>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\2026\supermarket-pos\resources\views/sales/show.blade.php ENDPATH**/ ?>