<?php $__env->startSection('page-title', 'تقرير المخزون'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header bg-white">
            <h5 class="mb-0"><i class="bi bi-box-seam"></i> تقرير المخزون</h5>
        </div>
        <div class="card-body">
            <div class="row g-3 mb-4">
                <div class="col-md-4">
                    <div class="stat-card primary">
                        <h6>قيمة المخزون الإجمالية</h6>
                        <h3><?php echo e(number_format($totalValue, 2)); ?> ج.م</h3>
                        <small>سعر التكلفة</small>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-card success">
                        <h6>الربح المحتمل</h6>
                        <h3><?php echo e(number_format($totalPotentialProfit, 2)); ?> ج.م</h3>
                        <small>عند بيع كل المخزون</small>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-card warning">
                        <h6>منتجات قليلة</h6>
                        <h3><?php echo e($lowStockCount); ?></h3>
                        <small>تحتاج إعادة طلب</small>
                    </div>
                </div>
            </div>

            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                    <tr>
                        <th>المنتج</th>
                        <th>الفئة</th>
                        <th>الكمية</th>
                        <th>سعر التكلفة</th>
                        <th>سعر البيع</th>
                        <th>قيمة المخزون</th>
                        <th>الربح المحتمل</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="<?php echo e($product->quantity <= $product->min_quantity ? 'table-warning' : ''); ?>">
                            <td><strong><?php echo e($product->name); ?></strong></td>
                            <td><span class="badge bg-info"><?php echo e($product->category->name); ?></span></td>
                            <td>
                                <?php if($product->quantity <= $product->min_quantity): ?>
                                    <span class="badge bg-danger"><?php echo e($product->quantity); ?></span>
                                <?php else: ?>
                                    <?php echo e($product->quantity); ?>

                                <?php endif; ?>
                            </td>
                            <td><?php echo e(number_format($product->cost_price, 2)); ?> ج.م</td>
                            <td><?php echo e(number_format($product->selling_price, 2)); ?> ج.م</td>
                            <td><strong><?php echo e(number_format($product->inventory_value, 2)); ?> ج.م</strong></td>
                            <td class="text-success"><?php echo e(number_format($product->potential_profit, 2)); ?> ج.م</td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center py-4">لا توجد منتجات</td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\2025\supermarket-pos\resources\views/reports/inventory.blade.php ENDPATH**/ ?>