<?php $__env->startSection('page-title', 'الموردين'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header bg-white d-flex justify-content-between align-items-center">
            <h5 class="mb-0"><i class="bi bi-truck"></i> قائمة الموردين</h5>
            <a href="<?php echo e(route('suppliers.create')); ?>" class="btn btn-primary">
                <i class="bi bi-plus-circle"></i> إضافة مورد جديد
            </a>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                    <tr>
                        <th>الاسم</th>
                        <th>الشركة</th>
                        <th>الهاتف</th>
                        <th>البريد الإلكتروني</th>
                        <th>عدد المشتريات</th>
                        <th>إجراءات</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><strong><?php echo e($supplier->name); ?></strong></td>
                            <td><?php echo e($supplier->company ?? '-'); ?></td>
                            <td><?php echo e($supplier->phone); ?></td>
                            <td><?php echo e($supplier->email ?? '-'); ?></td>
                            <td><span class="badge bg-info"><?php echo e($supplier->purchases_count); ?></span></td>
                            <td>
                                <a href="<?php echo e(route('suppliers.show', $supplier)); ?>" class="btn btn-sm btn-info btn-action">
                                    <i class="bi bi-eye"></i>
                                </a>
                                <a href="<?php echo e(route('suppliers.edit', $supplier)); ?>" class="btn btn-sm btn-primary btn-action">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <form action="<?php echo e(route('suppliers.destroy', $supplier)); ?>" method="POST" class="d-inline">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger btn-action"
                                            onclick="return confirm('هل أنت متأكد؟')">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center py-4">لا يوجد موردين</td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <?php echo e($suppliers->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\2026\supermarket-pos\resources\views/suppliers/index.blade.php ENDPATH**/ ?>