<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>فاتورة - <?php echo e($sale->invoice_number); ?></title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Courier New', monospace;
            width: 80mm;
            margin: 0 auto;
            padding: 10px;
        }
        .header {
            text-align: center;
            border-bottom: 2px dashed #000;
            padding-bottom: 10px;
            margin-bottom: 10px;
        }
        .header h2 { font-size: 20px; margin-bottom: 5px; }
        .header p { font-size: 12px; margin: 2px 0; }
        .info { margin-bottom: 10px; font-size: 12px; }
        .info p { margin: 3px 0; }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 10px 0;
            font-size: 12px;
        }
        table th {
            border-bottom: 1px solid #000;
            padding: 5px 0;
            text-align: right;
        }
        table td {
            padding: 5px 0;
            border-bottom: 1px dashed #ccc;
        }
        .totals {
            border-top: 2px solid #000;
            margin-top: 10px;
            padding-top: 10px;
            font-size: 14px;
        }
        .totals p {
            display: flex;
            justify-content: space-between;
            margin: 5px 0;
        }
        .totals .grand-total {
            font-size: 18px;
            font-weight: bold;
            border-top: 1px solid #000;
            padding-top: 5px;
        }
        .footer {
            text-align: center;
            margin-top: 20px;
            padding-top: 10px;
            border-top: 2px dashed #000;
            font-size: 12px;
        }
        @media print {
            body { width: 80mm; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>
<div class="header">
    <h2>🏪 سوبر ماركت</h2>
    <p>العنوان: شارع التحرير، المدينة</p>
    <p>تليفون: 0123456789</p>
</div>

<div class="info">
    <p><strong>رقم الفاتورة:</strong> <?php echo e($sale->invoice_number); ?></p>
    <p><strong>التاريخ:</strong> <?php echo e($sale->created_at->format('Y-m-d H:i:s')); ?></p>
    <p><strong>الكاشير:</strong> <?php echo e($sale->user->name); ?></p>
    <p><strong>طريقة الدفع:</strong>
        <?php if($sale->payment_method == 'cash'): ?> نقدي
        <?php elseif($sale->payment_method == 'card'): ?> بطاقة
        <?php else: ?> محفظة إلكترونية
        <?php endif; ?>
    </p>
</div>

<table>
    <thead>
    <tr>
        <th style="width: 50%">المنتج</th>
        <th style="width: 15%; text-align: center;">الكمية</th>
        <th style="width: 20%; text-align: left;">السعر</th>
        <th style="width: 15%; text-align: left;">المجموع</th>
    </tr>
    </thead>
    <tbody>
    <?php $__currentLoopData = $sale->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($item->product->name); ?></td>
            <td style="text-align: center;"><?php echo e($item->quantity); ?></td>
            <td style="text-align: left;"><?php echo e(number_format($item->unit_price, 2)); ?></td>
            <td style="text-align: left;"><strong><?php echo e(number_format($item->total_price, 2)); ?></strong></td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>

<div class="totals">
    <p>
        <span>المجموع الفرعي:</span>
        <span><?php echo e(number_format($sale->subtotal, 2)); ?> ج.م</span>
    </p>
    <?php if($sale->discount > 0): ?>
        <p>
            <span>الخصم:</span>
            <span>- <?php echo e(number_format($sale->discount, 2)); ?> ج.م</span>
        </p>
    <?php endif; ?>
    <?php if($sale->tax > 0): ?>
        <p>
            <span>الضريبة:</span>
            <span><?php echo e(number_format($sale->tax, 2)); ?> ج.م</span>
        </p>
    <?php endif; ?>
    <p class="grand-total">
        <span>الإجمالي:</span>
        <span><?php echo e(number_format($sale->total_amount, 2)); ?> ج.م</span>
    </p>
    <p>
        <span>المدفوع:</span>
        <span><?php echo e(number_format($sale->paid_amount, 2)); ?> ج.م</span>
    </p>
    <p>
        <span>الباقي:</span>
        <span><?php echo e(number_format($sale->change_amount, 2)); ?> ج.م</span>
    </p>
</div>

<div class="footer">
    <p>شكراً لزيارتكم 🙏</p>
    <p>نتمنى رؤيتكم مرة أخرى</p>
    <p style="margin-top: 10px;">* * * * * * * * * *</p>
</div>

<div class="no-print" style="text-align: center; margin-top: 20px;">
    <button onclick="window.print()" style="padding: 10px 30px; font-size: 16px; cursor: pointer;">
        طباعة الفاتورة
    </button>
    <button onclick="window.close()" style="padding: 10px 30px; font-size: 16px; cursor: pointer; margin-right: 10px;">
        إغلاق
    </button>
</div>

<script>
    // Auto print on load
    window.onload = function() {
        setTimeout(function() {
            window.print();
        }, 500);
    };
</script>
</body>
</html>
<?php /**PATH D:\2025\supermarket-pos\resources\views/pos/receipt.blade.php ENDPATH**/ ?>